clear

figure('Position', [200 80 1200 800])

% p = uipanel('Position',[.1 .0 .9 .9],'BorderType', 'none');
t = tiledlayout(4,6);
t.TileSpacing = 'none';
t.Padding = 'none';
title(t, 'Crank Phasing [deg]', 'FontWeight', 'Bold', 'FontSize', 12)
ylabel(t, {'Operating Point';'';'';''}, 'FontWeight', 'Bold', 'FontSize', 12)

Phase = 0:5:20;
ExPortH = 0.075:0.0125:0.225;
InPortH = 0.05:0.0125:0.2;

load('Opt_Data.mat')

BSFC_Matrices(:,:,:,1) = Lambda_Opt_A;
BSFC_Matrices(:,:,:,2) = Lambda_Opt_B;
BSFC_Matrices(:,:,:,3) = Lambda_Opt_C;


for j = 1:4
    if j < 4
        [BSFC_Matrices(:,:,6,j), Best_Phase(:,:,j)] = min(BSFC_Matrices(:,:,1:5,j),[],3);
    else
        BSFC_Matrices(:,:,:,j) = mean(BSFC_Matrices,4);
    end
    
    for i = 1:6
        nexttile(t)
        [c,h] = contourf(ExPortH,InPortH,BSFC_Matrices(:,:,i,j), (200:5:300), 'LineColor', [0.2 0.2 0.2]);
        clabel(c,h,'LabelSpacing',1000,'FontSize', 9);
        colormap(gca, flipud(turbo))
        caxis([200 300])
        set(gca, 'FontSize', 10)
        
        if j == 1 && i<6
            str = num2str(Phase(i));
            title({str;''}, 'FontWeight', 'bold', 'FontSize', 12)
        elseif j == 1 && i==6
            title({'Optimized';'Phasing'}, 'FontWeight', 'bold', 'FontSize', 12)
        end
        
        if i == 1
            yticks(0:0.05:0.3)
            ytickformat('%.2f')
        else
            set(gca,'Yticklabel',[])
        end
        
        if j == 3 && i == 1
            ylabel('                                              Intake Port Height Ratio', 'FontSize', 10)
        end
        
        if j == 4
            xticks(0:0.05:0.3)
            xtickformat('%.2f')
        else
            set(gca,'Xticklabel',[])
        end
        
%         str = (sprintf('(%c)',FigureLabels(((j-1)*5)+i)));
        
        if j == 4 && i == 3
            xlabel('                                             Exhaust Port Height Ratio', 'FontSize', 10)
        end

        axis('square')
        
        hold on
        [m,index] = min(BSFC_Matrices(:,:,i,j));
        [m2,index2] = min(m);
        x = ExPortH(index2);
        y = InPortH(index(index2));
        plot(x,y,'k+','MarkerSize', 15);
        text(x+0.004,y-0.008,num2str(m2,'%.2f'), 'Color', 'k', 'FontWeight', 'bold', 'FontSize', 10);
        hold off
    end
end

annotation('textbox', [0.03, 0.835, 0, 0], 'string', 'A', 'FontWeight', 'bold', 'FontSize', 15)
annotation('textbox', [0.03, 0.615, 0, 0], 'string', 'B', 'FontWeight', 'bold', 'FontSize', 15)
annotation('textbox', [0.03, 0.395, 0, 0], 'string', 'C', 'FontWeight', 'bold', 'FontSize', 15)
annotation('textbox', [0.015, 0.175, 0, 0], 'string', 'Average', 'FontWeight', 'bold', 'FontSize', 12)

cb = colorbar;
cb.Layout.Tile = 'east';
cb.Ticks = 200:20:300;
cb.FontSize = 10;
cb.Title.FontSize = 12;
cb.Title.String = {'BSFC'; 'g/kWh'};
